# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import CliModel

# NOTE The original submit history of MacFlapStatus and MacFlapDetectionWindow
# can be found in MacFlapCliHelpers.py

class MacFlapStatus( CliModel.Model ):
   status = CliModel.Bool( help="The current configuration of MAC Flap logging" )
   def render( self ):
      statusStr = "Host flap logging is %s."
      if self.status:
         statusStr = statusStr % "enabled"
      else:
         statusStr = statusStr % "disabled"
      print( statusStr )

class MacFlapDetectionWindow( CliModel.Model ):
   detectionWindow = CliModel.Int( help="The detection window for MAC "
                                        "Flapping, in seconds" )
   def render( self ):
      detectionWindowStr = "Host flap detection window is %d seconds." % \
            self.detectionWindow
      print( detectionWindowStr )

