# Copyright (c) 2006 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import CliMatcher
import Ethernet

#-------------------------------------------------------------------------------
# Rule for matching MAC addresses.  The value of this rule is the MAC address
# string as typed by the administrator.
#-------------------------------------------------------------------------------
def compareMacs( lhs, rhs ):
   '''Convert Mac address strings to Arnet.EthAddrs for comparison. Mac address
   strings can be in the form of either (mixed, or homogenous) XX.XX.XX or
   X:X:X:X:X:X'''
   if not lhs or not rhs:
      return False
   mac1 = Arnet.EthAddr( lhs )
   mac2 = Arnet.EthAddr( rhs )
   return mac1 == mac2

# New parser
class MacAddrMatcher( CliMatcher.PatternMatcher ):
   def __init__( self, helpname='H.H.H', helpdesc='Ethernet address', **kargs ):
      CliMatcher.PatternMatcher.__init__( self,
                                          pattern=Ethernet.macAddrPattern,
                                          helpname=helpname,
                                          helpdesc=helpdesc,
                                          **kargs )

macAddrMatcher = MacAddrMatcher()
