#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# Interface Mode:
#      -  [ no ] [ default ] loop-protection
#--------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import CliPlugin
import CliParser
import CliCommand
import CliMatcher
import ConfigMount
import LazyMount

config = None
bridgingHwCapabilities = None
allIntfConfigDir = None

#--------------------------------------------------------------------------------
# [ no ] [ default ] loop-protection
#--------------------------------------------------------------------------------
# Defaults to True - Interfaces protected by default, but need global enable
# and vlan enable for the protection to be active

def loopProtectSupportedGuard( mode, token ):
   if bridgingHwCapabilities.loopProtectSupported:
      return None
   return CliParser.guardNotThisPlatform

def intfLoopProtect( mode, args ):
   intf = str( mode.intf )
   del config.intfExclude[ intf ]

def noIntfLoopProtect( mode, args ):
   intf = str( mode.intf )
   config.intfExclude[ intf ] = True

class LoopProtectionCmd( CliCommand.CliCommandClass ):
   syntax = 'loop-protection'
   noOrDefaultSyntax = syntax
   data = {
      'loop-protection': CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 
         'loop-protection', helpdesc='Enable loop protection on this interface' ), 
         guard=loopProtectSupportedGuard ),
   }
   
   handler = intfLoopProtect
   noHandler = noIntfLoopProtect
   defaultHandler = handler

CliPlugin.IntfCli.IntfConfigMode.addCommandClass( LoopProtectionCmd )

def Plugin( entityManager ):
   global config
   global bridgingHwCapabilities
   global allIntfConfigDir

   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             'bridging/hwcapabilities',
                                             'Bridging::HwCapabilities', 'r' )
