#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# - [ no ] monitor loop-protection
#-------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import BasicCliModes
import CliParser
import CliCommand
import ConfigMount 
import LazyMount
import CliPlugin.LoopProtectCli as LoopProtectCli
from CliToken.Monitor import monitorMatcher
from CliPlugin.LoopProtectCli import TRANSMIT_INTERVAL_DEFAULT
from CliPlugin.LoopProtectCli import DISABLED_TIME_DEFAULT
from CliPlugin.LoopProtectCli import RATE_LIMIT_DEFAULT

config = None
bridgingHwCapabilities = None

#--------------------------------------------------------------------------------
# [ no | default ] monitor loop-protection
#--------------------------------------------------------------------------------
def loopProtectSupportedGuard( mode, token ):
   if bridgingHwCapabilities.loopProtectSupported:
      return None
   return CliParser.guardNotThisPlatform

def gotoMonitorLoopProtectMode( mode, args ):
   childMode = mode.childMode( LoopProtectCli.MonitorLoopProtectConfigMode )
   mode.session_.gotoChildMode( childMode )

def noMonitorLoopProtect( mode, args ):
   config.globalEnabled = False
   if config.transmitConfig:
      config.transmitConfig.rateLimit = RATE_LIMIT_DEFAULT
   if config.globalIntfConfig:
      config.globalIntfConfig.disabledTime = DISABLED_TIME_DEFAULT
      config.globalIntfConfig.transmitInterval = TRANSMIT_INTERVAL_DEFAULT
   config.vlanEnabled.clear()

class MonitorLoopProtectionCmd( CliCommand.CliCommandClass ):
   syntax = 'monitor loop-protection'
   noOrDefaultSyntax = syntax
   data = {
      'monitor': monitorMatcher,
      'loop-protection': CliCommand.guardedKeyword( 'loop-protection', 
         helpdesc='Monitor Loop Protection Configuration', 
         guard=loopProtectSupportedGuard ),
   }
   
   handler = gotoMonitorLoopProtectMode
   noOrDefaultHandler = noMonitorLoopProtect

BasicCliModes.GlobalConfigMode.addCommandClass( MonitorLoopProtectionCmd )

def Plugin( entityManager ):
   global config
   global bridgingHwCapabilities

   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )
   bridgingHwCapabilities = LazyMount.mount( entityManager,
                                             'bridging/hwcapabilities',
                                             'Bridging::HwCapabilities', 'r' )
