#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# This module implements the following commands:
#-------------------------------------------------------------------------------
# clear loop-protection counters
#--------------------------------------------------------------------------------

from __future__ import absolute_import, division, print_function

# pylint: disable=ungrouped-imports

import BasicCliModes
import CliCommand
import ConfigMount
from CliToken.Clear import clearKwNode

config = None

#--------------------------------------------------------------------------------
# clear loop-protection counters
#--------------------------------------------------------------------------------
def clearCounters( mode, args ):
   config.clearCounters += 1 # pylint: disable=E1103

class ClearLoopProtectionCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear loop-protection counters'
   data = {
      'clear': clearKwNode,
      'loop-protection': 'Loop Protection status',
      'counters': 'Counters for loop protection messages',
   }
   
   handler = clearCounters

BasicCliModes.EnableMode.addCommandClass( ClearLoopProtectionCountersCmd )

def Plugin( entityManager ):
   global config

   config = ConfigMount.mount( entityManager, 'loopprotect/config',
                               'LoopProtect::Config::Config', 'w' )
