# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from IntfRangePlugin.LogicalPort import LogicalPortPoolType
import BasicCli
import CliPlugin.LogicalPortModel as LogicalPortModel
import CliToken, CliToken.Hardware, ShowCommand
import Intf.IntfRange as IntfRange
import LazyMount

logicalPortStatusSliceDir = None

def getPoolStatusesAll( poolNames ):
   poolStatuses = {}
   for sliceDir in logicalPortStatusSliceDir.itervalues():
      for subSliceDir in sliceDir.itervalues():
         if not poolNames:
            poolStatuses.update( subSliceDir.poolStatus )
         else:
            for pool in poolNames:
               poolStatus = subSliceDir.poolStatus.get( pool )
               if poolStatus is not None:
                  poolStatuses[ pool ] = poolStatus
   return poolStatuses

def getPoolStatuses( poolNames ):
   statuses = getPoolStatusesAll( poolNames )
   poolStatuses = LogicalPortModel.PoolStatuses()
   if not statuses:
      return poolStatuses

   for name, status in statuses.iteritems():
      poolStatus = LogicalPortModel.PoolStatus()
      poolStatuses.pools[ name ] = poolStatus.toModel( status )

   return poolStatuses

# ------------------------------------------------------------------------------
# The "show hardware logical-port ( pool | POOL_RANGE ) status" command.
# ------------------------------------------------------------------------------
class ShowLogicalPortPoolCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware logical-port ( pool | POOL_RANGE ) status'
   data = {
      'hardware' : CliToken.Hardware.hardwareMatcherForShow,
      'logical-port' : 'Logical ports state',
      'pool' : 'Per-pool logical ports state',
      'POOL_RANGE': IntfRange.IntfRangeMatcher(
         explicitIntfTypes=( LogicalPortPoolType.type, ),
         dollarCompHelpText='Pool list end' ),
      'status' : 'Logical port pool status'
   }
   cliModel = LogicalPortModel.PoolStatuses

   @staticmethod
   def handler( mode, args ):
      poolRange = args.get( 'POOL_RANGE' )
      poolNames = []

      if poolRange:
         for name in IntfRange.intfListFromCanonical( [ poolRange ] ):
            poolNames.append( IntfRange.intfTypeFromName( name )[ 1 ] )

      return getPoolStatuses( poolNames )

BasicCli.addShowCommandClass( ShowLogicalPortPoolCmd )

def Plugin( em ):
   global logicalPortStatusSliceDir
   logicalPortStatusSliceDir = LazyMount.mount( em,
         "interface/archer/status/eth/phy/logicalport/slice", "Tac::Dir", "ri" )
