#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import CliCommand
import CliPlugin.LldpStatusCli as LldpStatusCli
from CliPlugin.LldpModel import ( Lldp, LldpNeighbors, LldpLocal, LldpTraffic,
                                  LldpNeighborsDetail )
from Intf.IntfRange import IntfRangeMatcher
from IntfRangePlugin.EthIntf import EthPhyAutoIntfType, MgmtPhyAutoIntfType
import ShowCommand

matcherLldp = CliMatcher.KeywordMatcher( 'lldp',
                     helpdesc='Show Link Layer Discovery Protocol (LLDP) status' )
matcherNeighbors = CliMatcher.KeywordMatcher( 'neighbors',
                     helpdesc='Show LLDP neighbors' )
intfRangeMatcher = IntfRangeMatcher( explicitIntfTypes=( EthPhyAutoIntfType,
                                               MgmtPhyAutoIntfType ) )
#------------------------------------------------------------------------------------
# show lldp [ INTFS ]
#------------------------------------------------------------------------------------

class LldpCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp [ INTFS ]'
   data = {
      'lldp' : matcherLldp,
      'INTFS' : intfRangeMatcher,
   }
   handler = LldpStatusCli.doShowLldp
   cliModel = Lldp

BasicCli.addShowCommandClass( LldpCmd )

#------------------------------------------------------------------------------------
# show lldp counters [ INTFS ]
#------------------------------------------------------------------------------------
class LldpCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp counters [ INTFS ]'
   data = {
      'lldp' : matcherLldp,
      'counters' : 'Show LLDP packet counters',
      'INTFS' : intfRangeMatcher,
   }
   handler = LldpStatusCli.doShowLldpCounters
   cliModel = LldpTraffic

BasicCli.addShowCommandClass( LldpCountersCmd )

#------------------------------------------------------------------------------------
# show lldp neighbors [ INTFS ]
#------------------------------------------------------------------------------------
class LldpNeighborsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp neighbors [ INTFS ]'
   data = {
      'lldp' : matcherLldp,
      'neighbors' : matcherNeighbors,
      'INTFS' : intfRangeMatcher,
   }
   handler = LldpStatusCli.doShowLldpNeighbors
   cliModel = LldpNeighbors

BasicCli.addShowCommandClass( LldpNeighborsCmd )

#------------------------------------------------------------------------------------
# show lldp neighbors [ INTFS ] detail
#------------------------------------------------------------------------------------
class LldpNeighborsDetailCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp neighbors [ INTFS ] detail'
   data = {
      'lldp' : matcherLldp,
      'neighbors' : matcherNeighbors,
      'INTFS' : intfRangeMatcher,
      'detail' : 'Show detailed information advertised by LLDP neighbors',
   }
   handler = LldpStatusCli.doShowLldpNeighborsDetail
   cliModel = LldpNeighborsDetail

BasicCli.addShowCommandClass( LldpNeighborsDetailCmd )

#------------------------------------------------------------------------------------
# show lldp local-info [ INTFS ]
#------------------------------------------------------------------------------------
class LldpLocalInfoCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp local-info [ INTFS ]'
   data = {
      'lldp' : matcherLldp,
      'local-info' : 'Show information that will be advertised by LLDP',
      'INTFS' : intfRangeMatcher,
   }
   handler = LldpStatusCli.doShowLldpLocalInfo
   cliModel = LldpLocal

BasicCli.addShowCommandClass( LldpLocalInfoCmd )

#------------------------------------------------------------------------------------
# show lldp traffic [ INTFS ]
#------------------------------------------------------------------------------------
class LldpTrafficCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show lldp traffic [ INTFS ]'
   data = {
      'lldp' : matcherLldp,
      'traffic' : CliCommand.Node( matcher=CliMatcher.KeywordMatcher( 'traffic',
                                          helpdesc='Show LLDP traffic statistics' ),
                                  deprecatedByCmd='show lldp counters [ INTFS ]' ),
      'INTFS' : intfRangeMatcher,
   }
   handler = LldpStatusCli.doShowLldpCounters
   cliModel = LldpTraffic

BasicCli.addShowCommandClass( LldpTrafficCmd )
