#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.LldpStatusCli as LldpStatusCli
from CliToken.Clear import clearKwNode

matcherLldp = CliMatcher.KeywordMatcher( 'lldp', helpdesc='Clear LLDP information' )

#------------------------------------------------------------------------------------
# clear lldp counters [ session ]
#-----------------------------------------------------------------------------------
class ClearLldpCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear lldp counters [ session ]'
   data = {
      'clear' : clearKwNode,
      'lldp' : matcherLldp,
      'counters' : 'Clear LLDP traffic counters',
      'session' : 'Clear LLDP traffic counters for the current CLI session only',
   }
   handler = LldpStatusCli.doClearLldpCounters

BasicCli.EnableMode.addCommandClass( ClearLldpCountersCmd )

#------------------------------------------------------------------------------------
# clear lldp table
#------------------------------------------------------------------------------------
class ClearLldpTableCmd( CliCommand.CliCommandClass ):
   syntax = 'clear lldp table'
   data = {
      'clear' : clearKwNode,
      'lldp' : matcherLldp,
      'table' : 'Clear all LLDP neighbors',
   }
   handler = LldpStatusCli.doClearLldpTable

BasicCli.EnableMode.addCommandClass( ClearLldpTableCmd )
