#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliMatcher
import CliPlugin.AclCli as AclCli
import CliPlugin.LanzCli as LanzCli
import CliPlugin.VrfCli as VrfCli

#--------------------------------------------------------------------------------
# [ no | default ] ip access-group ACL [ in ]
#--------------------------------------------------------------------------------
class IpAccessGroupCmd( CliCommand.CliCommandClass ):
   syntax = 'ip access-group ACL [ in ]'
   noOrDefaultSyntax = 'ip access-group ...'
   data = {
      'ip' : 'IP config commands',
      'access-group' : 'Configure access control list',
      'ACL' : AclCli.ipAclNameMatcher,
      'in' : 'Inbound packets',
   }

   handler = LanzCli.ipAclNameIs

   noOrDefaultHandler = LanzCli.ipAclNameDel

LanzCli.LanzStreamingMode.addCommandClass( IpAccessGroupCmd )

#--------------------------------------------------------------------------------
# [ no | default ] ipv6 access-group ACL [ in ]
#--------------------------------------------------------------------------------

class Ipv6AccessGroupCmd( CliCommand.CliCommandClass ):
   syntax = 'ipv6 access-group ACL [ in ]'
   noOrDefaultSyntax = 'ipv6 access-group ...'
   data = {
      'ipv6' : 'IPv6 config commands',
      'access-group' : 'Configure access control list',
      'ACL' : AclCli.ip6AclNameMatcher,
      'in' : 'Inbound packets',
   }

   handler = LanzCli.ipv6AclNameIs

   noOrDefaultHandler = LanzCli.ipv6AclNameDel

LanzCli.LanzStreamingMode.addCommandClass( Ipv6AccessGroupCmd )

#--------------------------------------------------------------------------------
# [ no | default ] max-connections MAXCONNECTIONS
#--------------------------------------------------------------------------------
class MaxConnectionsCmd( CliCommand.CliCommandClass ):
   syntax = 'max-connections MAXCONNECTIONS'
   noOrDefaultSyntax = 'max-connections'
   data = {
      'max-connections' : 'Set maximum number of client connections',
      'MAXCONNECTIONS' : CliMatcher.IntegerMatcher( 1, 100,
                        helpdesc='Maximum number of client connections',
                        helpname='<1-100>' ),
   }

   handler = LanzCli.LanzStreamingMode.setMaxConnections

   noOrDefaultHandler = LanzCli.LanzStreamingMode.defaultMaxConnections

LanzCli.LanzStreamingMode.addCommandClass( MaxConnectionsCmd )

#--------------------------------------------------------------------------------
# [ no ] [ default ] shutdown
#--------------------------------------------------------------------------------
class ShutdownCmd( CliCommand.CliCommandClass ):
   syntax = 'shutdown'
   noOrDefaultSyntax = syntax
   data = {
      'shutdown' : 'Disable queue-monitor streaming',
   }

   handler = LanzCli.LanzStreamingMode.shutdown

   noHandler = LanzCli.LanzStreamingMode.noShutdown

   defaultHandler = handler

LanzCli.LanzStreamingMode.addCommandClass( ShutdownCmd )

#--------------------------------------------------------------------------------
# [ no | default ] vrf VRF
#--------------------------------------------------------------------------------
class VrfCmd( CliCommand.CliCommandClass ):
   syntax = 'vrf VRF'
   noOrDefaultSyntax = 'vrf ...'
   data = {
      'vrf' : 'Specify VRF name to stream records',
      'VRF' : VrfCli.VrfNameExprFactory(),
   }

   handler = LanzCli.LanzStreamingMode.setVrf

   noOrDefaultHandler = LanzCli.LanzStreamingMode.setDefaultVrf

LanzCli.LanzStreamingMode.addCommandClass( VrfCmd )
