#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.LagGroupCli as LagGroupCli
import CliPlugin.LagIntfCli as LagIntfCli
import CliPlugin
from Intf.IntfRange import IntfRangeMatcher

#--------------------------------------------------------------------------------
# [ no | default ] interface INTERFACE
#--------------------------------------------------------------------------------
class InterfaceCmd( CliCommand.CliCommandClass ):
   syntax = 'interface INTERFACE'
   noOrDefaultSyntax = syntax
   data = {
      'interface': 'Configure member',
      'INTERFACE': IntfRangeMatcher( 
         explicitIntfTypes=set( [ LagIntfCli.LagAutoIntfType ] ) ),
   }
   handler = LagGroupCli.addIntf
   noOrDefaultHandler = LagGroupCli.remIntf

CliPlugin.IntfGroupLib.IntfGroupConfigMode.addCommandClass( InterfaceCmd )
