#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliMatcher
import CliPlugin.LagCli as LagCli
from CliToken.Clear import clearKwNode


#--------------------------------------------------------------------------------
# clear lacp [ LACP ] counters
#--------------------------------------------------------------------------------
class ClearLacpCountersCmd( CliCommand.CliCommandClass ):
   syntax = 'clear lacp [ LACP ] counters'
   data = {
      'clear': clearKwNode,
      'lacp': CliCommand.Node( 
         matcher=CliMatcher.KeywordMatcher( 
            'lacp', helpdesc='Link Aggregation Control Protocol (LACP) status' ), 
         guard=LagCli.lagSupportedGuard ),
      'LACP': CliMatcher.IntegerMatcher( 1, 2000, helpdesc='Channel Group ID' ),
      'counters': 'Clear LACP counters',
   }
   handler = LagCli.clearLacpCounters

BasicCliModes.EnableMode.addCommandClass( ClearLacpCountersCmd )
