# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CmdExtension
import sys
from FirewallCli import showFirewallSessionHook
from FirewallCli import clearFirewallSessionHook
from FirewallCli import clearFirewallCountersHook
from FirewallCli import fwConsts
import subprocess

def showKernelFirewallSessions( mode, vrfName ):
   if not vrfName:
      vrfName = 'default'
   connmark = hex( fwConsts.connmark ).rstrip( 'L' )
   cmd = [ 'sudo', '/usr/sbin/conntrack', '-L', '-m', connmark ]
   cliCmdExt = CmdExtension.getCmdExtender()

   entryExists = False
   headings = ( ' Src', ' SrcPort', ' Dst', ' DstPort', ' Protocol' )
   colFormat = "  %-18s%-9s%-18s%-9s%-10s"
   headerLine = "  "
   for w in ( 17, 8, 17, 8, 9 ):
      headerLine += ( '-' * w ) + ' '

   try:
      p = cliCmdExt.subprocessPopen( cmd, mode.session, vrfName=vrfName,
                                     stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE )
      out, _ = p.communicate()
      for line in out.splitlines():
         fields = line.split()
         if len( fields ) < 3:
            continue
         flow = { 'proto': fields[ 0 ], 'src': '', 'dst': '',
                  'sport': '', 'dport': '' }
         for field in fields:
            tup = field.split( '=' )
            if len( tup ) == 2:
               k = tup[ 0 ]
               v = tup[ 1 ]
               if flow.has_key( k ) and flow[ k ] == '':
                  flow[ k ] = v
         if flow[ 'src' ] == '':
            continue

         # When there are more than 100k sessions, then preparing table object
         # can consume huge memory and cpu usage. So print the output directly
         # without the table object.
         if not entryExists:
            entryExists = True
            print colFormat % headings
            print headerLine
         sys.stdout.write( colFormat % ( flow[ 'src' ], flow[ 'sport' ],
                           flow[ 'dst' ], flow[ 'dport' ], flow[ 'proto' ] ) )
         sys.stdout.write( "\n" )
   except EnvironmentError as e:
      mode.addWarning( e.strerror )
      return
   except KeyboardInterrupt:
      pass

   if not entryExists:
      print "No active flows"
   else:
      print

def clearKernelFirewallSessions( mode, vrfName ):
   if not vrfName:
      vrfName = 'default'
   connmark = hex( fwConsts.connmark ).rstrip( 'L' )
   cmd = [ 'sudo', '/usr/sbin/conntrack', '-D', '-m', connmark ]
   try:
      cliCmdExt = CmdExtension.getCmdExtender()
      p = cliCmdExt.subprocessPopen( cmd, mode.session, vrfName=vrfName,
                                     stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE )
      p.communicate()
   except EnvironmentError as e:
      mode.addWarning( e.strerror )

def clearKernelFirewallCounters( mode, vrfName ):
   if vrfName is None:
      vrfName = 'default'
   cmd = [ 'sudo', 'iptables', '-Z' ]
   try:
      cliCmdExt = CmdExtension.getCmdExtender()
      p = cliCmdExt.subprocessPopen( cmd, mode.session, vrfName=vrfName,
                                     stdout=subprocess.PIPE,
                                     stderr=subprocess.PIPE )
      p.communicate()
   except EnvironmentError as e:
      mode.addWarning( e.strerror )

showFirewallSessionHook.addExtension( showKernelFirewallSessions )
clearFirewallSessionHook.addExtension( clearKernelFirewallSessions )
clearFirewallCountersHook.addExtension( clearKernelFirewallCounters )
