#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import Tac
from Ark import ReversibleDict

LEVEL_MAP = { 1 : 'level1',
              2 : 'level2',
              3 : 'level1-2' }

ADDRESS_FAMILY_MAP = { 0 : 'ipv4',
                       1 : 'ipv6',
                       2 : 'both' }

IS_TYPE_MAP = { "level1" : "Level 1",
                "level2" : "Level 2",
                "level1-2" : "Level 1 and 2",
                "unknown" : "Level unknown" }

ROUTE_MAP = { "ipv4" : "  Routes IPv4 only",
              "ipv6" : "  Routes IPv6 only",
              "both" : "  Routes both IPv4 and IPv6",
              "none" : "" }

AUTHENTICATION_MAP = { "none" : "None",
                       "md5" : "MD5",
                       "text" : "Text",
                       "sha" : "SHA" }

BFD_STATE_MAP = { 0 : 'adminDown',
                  1 : 'init',
                  2 : 'down',
                  3 : 'up' }

LEVEL_TYPE_MAP = { 'Level 1 IS' : 'level-1',
                   'Level 2 IS' : 'level-2',
                   'Level 1 and 2 IS' : 'level-1-2' }

STATE_MAP = { 'INIT' : 'init',
              'UP' : 'up',
              'DOWN' : 'down' }

LEVEL_SHORT_MAP = { 'level-1' : 'L1',
                    'level-2' : 'L2',
                    'level-1-2' : 'L1L2' }

INTF_SRLG_FLAG_MAP = { 0 : 'Unnumbered',
                       1 : 'Numbered' }

def elapsedTime( timeElapsed ):
   m, s, h, d = 0, 0, 0, 0
   ts = int( Tac.utcNow() - timeElapsed )
   if ts < 0:
      result = "-"
   else:
      result = ""
   m, s = divmod( ts , 60 )
   h, m = divmod( m, 60 )
   d, h = divmod( h, 24 )
   if d:
      result += "%dd%02dh" % ( d, h )
   else:
      result += "%02d:%02d:%02d" % ( h, m, s )
   return result

# hh:mm:ss.ms to seconds.milliseconds
def ribdToSecTime( t ):
   return reduce( lambda sum, part: part + sum * 60,
                  [ float( i ) for i in t.split( ':' ) ] )

# if msecUsed is False, seconds to h:m:s conversion
# if msecUsed is True, seconds to hh:mm:ss.ms (PDT) conversion
def secToRibdTime( t, msecUsed=False ):
   h = int ( t // 3600 )
   m = int ( t //60 ) % 60
   s = ( t % 60 )
   T = str( "%02d:%02d:%06.3f" % ( h, m, s ) )
   if not msecUsed:
      return T.lstrip( "0:" ).split( "." )[ 0 ]
   return T

ISIS_LSP_FLAGS_MAP = ReversibleDict( {
   'partitionSupport' : "PartSupport",
   'errorAttached' : "ErrorAtt",
   'expenseAttached' : "ExpenseAtt",
   'delayAttached' : "DelayAtt",
   'defaultAttached' : "DefaultAtt",
   'dbOverload' : "DBOverload",
   } )

AUTH_MODE_MAP = { 3: "SHA",
                  2: "Text",
                  1: "MD5"
}

ADJ_SID_SUBTLV_FLAGS = { 'ISIS_SR_ADJ_SET' : 0x8,
                         'ISIS_SR_ADJ_LOCAL': 0x10,
                         'ISIS_SR_ADJ_VALUE': 0x20,
                         'ISIS_SR_ADJ_BACKUP': 0x40,
                         'ISIS_SR_ADJ_AF': 0x80,
}

PREFIX_SEGMENT_FLAGS = {'ISIS_SR_PFX_PROXY_NODE' : 0x100,
                        'ISIS_SR_PFX_READVERT' : 0x80,
                        'ISIS_SR_PFX_NODE' : 0x40,
                        'ISIS_SR_PFX_NOPHP' : 0x20,
                        'ISIS_SR_PFX_EXPLICIT_NULL' : 0x10,
                        'ISIS_SR_PFX_VALUE' : 0x8,
                        'ISIS_SR_PFX_LOCAL': 0x4,
}

AREA_SEGMENT_FLAGS = {'ISIS_SR_AREA_SEGMENT_AF' : 0x80,
                      'ISIS_SR_AREA_SEGMENT_VALUE' : 0x40,
                      'ISIS_SR_AREA_SEGMENT_LOCAL' : 0x20,
}

SR_ALGO_SPF = "SPF"
SR_ALGO_SSPF = "SSPF"
SR_ALGO_UNDEFINED = "undefined"

SR_ALGO_MAP = ReversibleDict( { 1 :SR_ALGO_SSPF, 0:SR_ALGO_SPF  } )

RTR_CAPABILITY_MAP = {'ISIS_RTR_CAP_FLAG_S' : 1,
                      'ISIS_RTR_CAP_FLAG_D' : 2,
}

SRCAPABILITY_MAP = { 'ISIS_SR_CAP_MPLS_IPV4' : 0x80,
                     'ISIS_SR_CAP_MPLS_IPV6' : 0x40,
                     'ISIS_SR_CAP_IPV6' : 0x20,
}

NLPID_MAP = [ ( " 0xCC(IPv4)", 2 ), ( " 0x8E(IPv6)", 4 ), ( " 0x81(CLNP)", 1 ) ]

SR_BINIDING_MAP = { 'ISIS_SR_BINDING_ATTACH' : 0x8,
                    'ISIS_SR_BINDING_LEAK' : 0x10,
                    'ISIS_SR_BINDING_FLOOD' : 0x20,
                    'ISIS_SR_BINDING_MIRROR' : 0x40,
                    'ISIS_SR_BINDING_AF' : 0x80,
}

METRIC_TYPE_INTERNAL = 1
METRIC_TYPE_EXTERNAL = 2

METRIC_TYPE_MAP = ReversibleDict( { METRIC_TYPE_INTERNAL: "Internal",
                                    METRIC_TYPE_EXTERNAL: "External" } )

ADDR_TOPO_RENDER_MAP = {
      "ipv4" : "IPv4",
      "ipv6" : "IPv6",
      "ipv4, ipv6" : "IPv4, IPv6",
      "both" : "IPv4, IPv6",
      "unknown" : "Unknown",
      "none" : ""
}

INTERFACE_TYPES_MAP = {
      1 : "broadcast",
      2 : "point-to-point",
      3 : "loopback",
}

INTERFACE_ADDR_MAP = {
      1 : "ipv4",
      2 : "ipv6",
      3 : "ipv4, ipv6"
}

INTERFACE_ADJ_TYPE_MAP = ReversibleDict({ "l1" : "Level 1 IS",
                                          "l2" : "Level 2 IS",
                                          "l1l2" : "Level 1 and 2 IS",
                                          "es" : "ES",
                                          "unknown" : "unknown" })

INTERFACE_LEVEL_RENDER_MAP = {
      'level1' : '1',
      'level2' : '2',
      'level1-2' : '1 and 2',
      'unknown' : 'unknown'
}

INTERFACE_ADJ_STATE_MAP = ReversibleDict({ "init" : "INIT",
                                           "up" : "UP",
                                           "failed" : "FAILED",
                                           "down" : "DOWN" })

PKT_DROP_REASON_MAP = { 'shortHeaders' : 'Short Headers',
                         'wrongVersion' : 'Wrong IS-IS Version',
                         'idFieldLengthMismatches' : 'System Id Field Length '
                         'Mismatches',
                         'badLength' : 'Bad Packet Length',
                         'malformedTlv' : 'Malformed Tlv',
                         'authFailure' : 'Auth Failure',
                         'circuitTypeMismatches' : 'Circuit Type Mismatches',
                         'ownSystemIdPdu' : 'Own System Id Pdu',
                         'unknownCircuitType' : 'Unknown Circuit Type',
                         'lengthGreaterThanMTU' : 'Length Greater Than MTU',
                         'badOptionLength' : 'Bad Option Length',
                         'noSupportedProtocols' : 'No Supported Protocols',
                         'topoSuppProtocolsMismatch' : 'Topology And Supported'
                         ' Protocols Mismatch',
                         'protocolAddressesMismatch' :'Protocols And Addresses'
                         ' Mismatch',
                         'supportedProtocolsMismatch' : 'Supported Protocols '
                         'Mismatch',
                         'incompatibleAdjAttrs' : 'Incompatible Adjacency '
                         'Attributes',
                         'badAreaOption' : 'Bad Area Option',
                         'maxAreaAddressMismatch' : 'Max Area Addresses '
                         'Mismatch',
                         'noMatchingAreas' : 'No Matching Areas',
                         'noRemTimeInRestartTlvWithRA' : 'No Remaining Time '
                         'Set In Reastart Tlv With RA',
                         'noCommonTopology' : 'No Common Topology',
                         'badAdjStateOption' : 'Bad Adjacency State Option',
                         'nonMatchingThreeWayHandshake' : 'Non Matching '
                         'Three Way Handshake',
                         'noSourceMac' : 'No Source Mac',
                         'circuitLevelMismatch' : 'Circuit Level Mismatch',
                         'neighbourSysIdChanged' : 'Neighbour System Id '
                         'Changed',
                         'dupSysIdDetected': 'Duplicate System Id Detected',
                         'missingAreas' : 'Missing Areas',
                         'ngbSysIdMismatchInRestartTLVWithRA' : 'Ngb System Id'
                         ' Mismatch In restart Tlv With RA',
                         'nonAdjSource' : 'Non Adjacent Source',
                         'parsingFailure' : 'Parsing Failure',
                         'invalidPurge' : 'Invalid Purge',
                         'badLspLength' : 'Bad Lsp Length',
                         'badChecksum' : 'Bad Checksum',
                         'ownLspPurge' : 'Own Lsp Purge',
                         'olderPurgeLsp' : 'Older Purge Lsp',
                         'ownExpiredLsp' : 'Own Expired Lsp',
                         'differentChecksumLsp' : 'Different Checksum Lsp',
                         'ownNewerSequenceLsp' : 'Own Newer Sequence Number '
                         'Lsp',
                         'olderLsp' : 'Older Lsp',
                         'invalidLspEntryOption' : 'Invalid Lsp Entry Option',
                         'psnpOnNonDisSystem' : 'Psnp Received On Non-DIS'
}

PKT_DROP_TYPE_MAP = { 'Malformed Pdus' : 'malformedPdusDropReasons',
                      'IIH P2P' : 'iihP2pDropReasons',
                      'IIH L1' : 'iihLanL1DropReasons',
                      'IIH L2' : 'iihLanL2DropReasons',
                      'CSNP L1': 'csnpL1DropReasons',
                      'CSNP L2': 'csnpL2DropReasons',
                      'PSNP L1': 'psnpL1DropReasons',
                      'PSNP L2': 'psnpL2DropReasons',
                      'LSP L1' : 'lspL1DropReasons',
                      'LSP L2' : 'lspL2DropReasons'
}

isisDropPduTypes = [ 'Malformed Pdus', 'IIH P2P', 'IIH L1', 'IIH L2', 'CSNP L1',
                     'CSNP L2', 'PSNP L1', 'PSNP L2', 'LSP L1', 'LSP L2' ]

GRACEFUL_RESTART_STATE_MAP = { 
   'grDisabledOnStartup' : 'Graceful Restart disabled during startup',
   'grInProgress' : 'Restart in progress',
   'grStartInProgress' : 'Start in progress',
   'grLastRestart' : 'Last Restart was completed successfully',
   'grLastStart' : 'Last Start was completed successfully',
   'grLastRestartT2Level1' : 'Last Restart exited after T2 (level-1) expiry',
   'grLastRestartT2Level2' : 'Last Restart exited after T2 (level-2) expiry',
   'grLastRestartT3' : 'Last Restart exited after T3 expiry',
   'grLastStartT2Level1' : 'Last Start exited after T2 (level-1) expiry',
   'grLastStartT2Level2' : 'Last Start exited after T2 (level-2) expiry',
   'grInvalidState' : '',
}

ENABLED_DISABLED_MAP = { 
   'enabled' : 'Enabled',
   'disabled': 'Disabled',
}

YES_NO_MAP = {
   True : 'Yes',
   False : 'No',
}

GRACEFUL_RESTART_STATUS_MAP = {
   'starting' : 'Starting',
   'reStarting' : 'Restarting',
   'running' : 'Running',
   'na' : 'NA'
}

TILFA_PROTECTION_MAP = {
   0 : "disabled",
   1 : "link",
   2 : "node"
}

SRLG_PROTECTION_MAP = {
   1 : 'loose',
   2 : 'strict'
}

# new_isis/new_isis_uloop.c, isis_uloop_state_dget_str()
ULOOP_SM_STATE_RENDER_MAP = { 
   'delayNotRunnng'    : 'Not running',
   'delayStarted'      : 'Started',
   'delaySpfScheduled' : 'SPF scheduled',
   'delayRoutes'       : 'Routes delayed',
   'delayRoutesNewSpf' : 'Routes delayed, new SPF scheduled',
}

# new_isis/new_isis_uloop.c, isis_uloop_cause_dget_str()
ULOOP_SM_CAUSE_RENDER_MAP = { 
   'linkDown' : 'LINK DOWN',
   'bfdDown'  : 'BFD DOWN',
}

# new_isis/new_isis_uloop.c, isis_uloop_result_dget_str()
ULOOP_SM_RESULT_RENDER_MAP = { 
   'delaySucceeded'                : 'Succeeded',
   'delayAbortedLinkDown'          : 'Aborted on link down',
   'delayAbortedLinkUp'            : 'Aborted on link up',
   'delayAbortedSpfNotScheduled'   : 'Aborted, SPF not scheduled',
   'delayAbortedStateStarted'      : 'Aborted during start',
   'delayAbortedSpfScheduled'      : 'Aborted, SPF scheduled',
   'delayAbortedDelayRoutes'       : 'Aborted after routes delayed',
   'delayAbortedDelayRoutesNewSpf' : 'Aborted waiting for new SPF',
   'delayAbortedCleanup'           : 'Aborted on cleanup',
}
