# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-----------------------------------------------------
# Register Ira show commands into "show tech-support".
#-----------------------------------------------------
from CliPlugin.IraNexthopGroupCli import nexthopGroupSupportedGuard
from CliPlugin.IraIp6Cli import ipV6Vrf
import TechSupportCli

def _showTechCmds1():
   cmds1 = [ 'show ip route vrf all detail',
             'show ip route vrf all host',
           ]
   return cmds1

def _showTechCmds2():
   cmds2 = [ 'show kernel ip route vrf all',
             'show kernel interface addr vrf all',
             'show kernel ip acl vrf all',
             'show kernel ip counters vrf all',
           ]
   if ipV6Vrf( mode=None, token=None ) is None:
      cmds2.append( 'show kernel ipv6 counters vrf all' )
   return cmds2

def _showTechCmds3():
   cmds = []
   if nexthopGroupSupportedGuard( mode=None, token=None ) is None:
      # Guard returns 'None' iff nexthop groups are supported on this platform.
      # NB: The "show tech-support" callbacks are executed at the time that
      #     "show tech-support" is actually executed, so the guard check is valid.
      cmds.append( 'show nexthop-group' )
   return cmds

def _showTechCmdsArpTables():
   '''
   Dump the Arp/ND tables from the kernel. If V6 is not supported in non-default VRF,
   then the 'vrf' keyword will not work.
   '''
   # The use of 'vrf all' commands (and the guard directly) causes a subtle state
   # dependence: this show tech plugin depends on IraIp6Cli.Plugin having been run
   # (ie. the CLI plugin loaded), which does not happen automatically when the module
   # is imported.
   v6Cmd = 'show kernel ipv6 neighbors'

   # This fn is actually a CLI guard, hence weird name and weird return value
   if ipV6Vrf( mode=None, token=None ) is None:
      v6Cmd += ' vrf all'
   return [ 'show kernel ip arp vrf all', v6Cmd ]

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:06:10',
                                _showTechCmds1 )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:22:00',
                                _showTechCmds2 )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2015-05-05 17:36:50',
                                _showTechCmds3 )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback(
      "2016-12-19 09:27:00",
      lambda: [ "show vrf" ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback(
      "2017-04-07 09:27:00",
      lambda: [ "show ip route vrf all summary" ],
      summaryCmdCallback=lambda: [
         "show ip interface brief",
         "show ip route vrf all summary",
         ] )

# Timestamps are made up to maintain historical order within show tech-support
TechSupportCli.registerShowTechSupportCmdCallback( '2019-11-08 08:52:00',
                                                   _showTechCmdsArpTables )

TechSupportCli.registerShowTechSupportCmdCallback(
      '2020-06-30 18:27:13',
      summaryCmdCallback=lambda: [ 'show vrf summary' ] )

#--------------------------------------------------------------------------
# register show tech-support extended evpn
#--------------------------------------------------------------------------
def _showTechEvpnCmds():
   return [
            'show ip route',
          ]

TechSupportCli.registerShowTechSupportCmdCallback( '2017-11-03 12:06:19',
                                                   _showTechEvpnCmds,
                                                   extended='evpn' )
