# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliExtensions
import CliParser
import CliCommand
import CliPlugin.VrfCli as VrfCli
from CliMode.Ira import RouterKernelMode
from CliToken.Router import routerMatcherForConfig as keywordRouter
from IpLibConsts import DEFAULT_VRF

import Tracing
# To be able to mount hwEpoch/status when loading plugin:
# pkgdeps: rpmwith %{_libdir}/preinit/HwEpoch
traceHandle = Tracing.Handle( 'IraRouterKernel' )
t5 = traceHandle.trace5 # Info

routerKernelVrfHook = CliExtensions.CliHook()

#-------------------------------------------------------------------------------
# router kernel - config mode. 
#-------------------------------------------------------------------------------
class RouterKernelConfigMode( RouterKernelMode, BasicCli.ConfigModeBase ):
   name = 'Kernel Route configuration'
   modeParseTree = CliParser.ModeParseTree()

   #----------------------------------------------------------------------------
   # Constructs a new RouterKernelConfigMode instance.
   #----------------------------------------------------------------------------
   def __init__( self, parent, session, vrfName ):
      RouterKernelMode.__init__( self, ( vrfName ) )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

def gotoRouterKernelConfigMode( mode, args ):
   vrfName = args.get( "VRF", DEFAULT_VRF )
   t5( "Switcing to router kernel mode, vrf", vrfName )
   childMode = mode.childMode( RouterKernelConfigMode, vrfName=vrfName )
   mode.session_.gotoChildMode( childMode )
   # Create the vrf config if it does not exist
   routerKernelVrfHook.notifyExtensions( vrfName, True )
 
def deleteRouterKernelConfigMode( mode, args ):
   vrfName = args.get( "VRF", DEFAULT_VRF )
   if not vrfName:
      vrfName = DEFAULT_VRF
   t5( "Switcing to router kernel mode, vrf", vrfName )
   # Delete the vrf config if we are deleting the mode
   routerKernelVrfHook.notifyExtensions( vrfName, False )

class RouterKernelConfigModeCmd( CliCommand.CliCommandClass ):
   syntax = 'router kernel [ VRF ]'
   noOrDefaultSyntax = syntax

   data = {
      'router': keywordRouter,
      'kernel': 'Routes installed by kernel',
      'VRF': VrfCli.VrfExprFactory( helpdesc='VRF name',
                                    inclDefaultVrf=True ),
   }

   handler = gotoRouterKernelConfigMode
   noOrDefaultHandler = deleteRouterKernelConfigMode

BasicCli.GlobalConfigMode.addCommandClass( RouterKernelConfigModeCmd )
