# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#------------------------------------------------------------------------------
# Implements routing related Etba commands
#
# maximim-paths: Set "hardware" maximum ecmp paths. Maybe set at init.
#------------------------------------------------------------------------------

import CliMatcher, CliCommand, ShowCommand, BasicCli
import LazyMount, Tac
#from BridgingEtbaCli import tokenEtba

routingHwStatus = None
routing6HwStatus = None

# Has to copy from BridgingEtbaCli to avoid circular dep.
etbaKw = CliMatcher.KeywordMatcher( 'etba',
           helpdesc='Ebra Test Bridge configuration commands' )

maxEcmpKw = CliMatcher.KeywordMatcher(
   "maximum-paths",
   helpdesc="Maximum etba dut ECMP paths" )

def setMaxEcmp( mode, args ):
   maxEcmp = args.get( 'MAX', 16 )
   routingHwStatus.maxEcmp = maxEcmp
   routing6HwStatus.maxEcmp = maxEcmp
   routingHwStatus.maxUcmp = maxEcmp
   routing6HwStatus.maxUcmp = maxEcmp

def showEtbaMaximumPathsCmd():
   return "show etba maximum-paths"

def showMaxEcmp( mode ):
   print "maximum-paths: %d, ipv6: %d " % (
      routingHwStatus.maxEcmp, routing6HwStatus.maxEcmp )

class SetMaxEcmpCmd( CliCommand.CliCommandClass ):
   syntax = '''etba maximum-paths MAX'''
   noOrDefaultSyntax = '''etba maximum-paths ...'''
   data = { 'etba': etbaKw,
            'maximum-paths': maxEcmpKw,
            'MAX': CliMatcher.IntegerMatcher( 0, 128, helpdesc="Maximum paths" )
          }

   handler = setMaxEcmp
   noOrDefaultHandler = handler

BasicCli.GlobalConfigMode.addCommandClass( SetMaxEcmpCmd )

class ShowMaxEcmpCmd( ShowCommand.ShowCliCommandClass ):
   syntax = '''show etba maximum-paths'''
   data = { 'etba': etbaKw,
            'maximum-paths': maxEcmpKw
          }

   @staticmethod
   def handler( mode, args ):
      showMaxEcmp( mode )

BasicCli.addShowCommandClass( ShowMaxEcmpCmd )

def Plugin( entityManager ):
   global routingHwStatus
   global routing6HwStatus

   # These are not Cli Config roots --- so we don't use ConfigMount, even
   # though they are being mounted "w".  Normally setting maxEcmp is a property
   # of the system, and not typically set by the Cli.  However, for etba
   # duts, for testing purposes, this is a cli configurable property.
   routingHwStatus = LazyMount.mount( entityManager, "routing/hardware/status",
                                        "Routing::Hardware::Status", "w" )
   routing6HwStatus = LazyMount.mount( entityManager, 'routing6/hardware/status',
                                         'Routing6::Hardware::Status', 'w' )


   
