#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from CliModel import List
from CliModel import Bool
from CliModel import Model

#-------------------------------------------------------------------
# model for "show ip hardware fib load-balance distribution"
#-------------------------------------------------------------------

class GlobalDlb( Model ):
   globalDlbEcmpEnabled = \
           Bool( help="Whether or not dynamic load balancing is enabled globally" )
   dlbEcmpNhg = List( valueType=str,
                      help="Dynamic load balancing enabled static nexthop groups" )

   def render ( self ):
      print ""
      if self.globalDlbEcmpEnabled:
         print "Global load balance distribution: Dynamic"
      else:
         print "Global load balance distribution: Hash"
      if len( self.dlbEcmpNhg ):
         print "Nexthop groups with dynamic load balancing enabled: "
         for nhgName in self.dlbEcmpNhg:
            print nhgName
