#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function
import BasicCli
import ShowCommand
import Toggles.IpLockingToggleLib as ILTL
from CliPlugin.IntfCli import Intf
from CliPlugin.IpLockingCli import (
   doShowIpLocking, doShowIpLockingServers, doShowAddressLockingTable,
   doShowIpLockingCounters
)
from CliPlugin.IpLockingModel import IpLocking, IpLockingServers, LeasesTable
from CliPlugin.IpLockingCounterModel import IpLockingCountersModel
from CliToken.IpLocking import (
   ipLockingAddressMatcherForShow,
   ipLockingLockingMatcherForShow,
   ipLockingTableMatcherForShow,
   ipLockingIpv4MatcherForShow,
   ipLockingStaticMatcherForShow,
   ipLockingDynamicMatcherForShow,
   ipLockingInterfasceMatcherForShow,
   ipLockingInstalledMatcherForShow,
   ipLockingCountersMatcherForShow,
   ipLockingServersMatcherForShow,
)

class IpLockingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
   }
   handler = doShowIpLocking
   cliModel = IpLocking

class IpLockingServersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking servers'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'servers': ipLockingServersMatcherForShow,
   }
   handler = doShowIpLockingServers
   cliModel = IpLockingServers

class AddressLockingTableCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show address locking table ipv4 [ static | dynamic ] '
              '[ interface INTF ] [ installed ]' )
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'table': ipLockingTableMatcherForShow,
      'ipv4': ipLockingIpv4MatcherForShow,
      'static': ipLockingStaticMatcherForShow,
      'dynamic': ipLockingDynamicMatcherForShow,
      'interface': ipLockingInterfasceMatcherForShow,
      'INTF': Intf.matcher,
      'installed': ipLockingInstalledMatcherForShow
   }
   handler = doShowAddressLockingTable
   cliModel = LeasesTable

class IpLockingCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show address locking counters'
   data = {
      'address': ipLockingAddressMatcherForShow,
      'locking': ipLockingLockingMatcherForShow,
      'counters': ipLockingCountersMatcherForShow,
   }
   handler = doShowIpLockingCounters
   cliModel = IpLockingCountersModel

BasicCli.addShowCommandClass( IpLockingCmd )
BasicCli.addShowCommandClass( AddressLockingTableCmd )
BasicCli.addShowCommandClass( IpLockingServersCmd )
if ILTL.toggleIpLockingCountersEnabled():
   BasicCli.addShowCommandClass( IpLockingCountersCmd )
