#!/usr/bin/env python
# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Cell
import LazyMount
import Tac
import SharedMem
import Smash

entityManager = None
smashEntityManager = None
writerConfigDir = None

def _getCurrentCounterPath( writerMountName ):
   return "counters/queue/" + writerMountName + "/current"

def _getClearCounterPath( writerMountName ):
   return "counters/queue/" + writerMountName + "/lastClear"

def _mountCounters():
   allIntfQueueCounters = {}
   allIntfQueueClearCounters = {}
   queueCounterMountInfo = Smash.mountInfo( 'reader' )
   for name in writerConfigDir:
      if name in allIntfQueueCounters:
         continue
      entry = writerConfigDir[ name ]
      allIntfQueueCounters[ name ] = smashEntityManager.doMount(
         _getCurrentCounterPath( entry.writerMountName ),
         "Interface::QueueCounter::AllIntfQueueCounters", queueCounterMountInfo )
      allIntfQueueClearCounters[ name ] = smashEntityManager.doMount(
         _getClearCounterPath( entry.writerMountName ),
         "Interface::QueueCounter::AllIntfQueueCounters", queueCounterMountInfo )
   return ( allIntfQueueCounters, allIntfQueueClearCounters )

def getCounterAccessor():
   counterAccessor = Tac.newInstance( 'Interface::QueueCounter::CounterAccessor' )
   allIntfQueueCounters, allIntfQueueClearCounters = _mountCounters()

   for key, data in allIntfQueueCounters.iteritems():
      counterAccessor.mountPathToQueueCounter[ key + '/current' ] = data
   for key, data in allIntfQueueClearCounters.iteritems():
      counterAccessor.mountPathToQueueCounter[ key + '/lastClear' ] = data

   for writerConfig in writerConfigDir.values():
      writerConfigMetaData = Tac.Value( 'Interface::QueueCounter::MetaData',
                                        writerConfig.numUnicastQueues,
                                        writerConfig.numMulticastQueues,
                                        writerConfig.writerMountName )
      for intf in writerConfig.intf:
         counterAccessor.intfMetaData[ intf ] = writerConfigMetaData
   return counterAccessor

def Plugin( em ):
   global writerConfigDir, entityManager, smashEntityManager
   entityManager = em
   smashEntityManager = SharedMem.entityManager( sysdbEm=em )
   writerConfigDir = LazyMount.mount(
      entityManager, Cell.path( 'interface/queueCounter/writerConfigDir' ),
      'Tac::Dir', 'ri' )
