#!/usr/bin/env python
# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac
from CliModel import Submodel, Model, GeneratorDict, Str
from IntfModels import Interface
from CliPlugin.MaintenanceModels import MaintenanceInterfaceStatus
from CliPlugin.MaintenanceModels import InterfaceProfile
from MaintenanceCliLib import maintenanceStateToStr


class IntfMaintenanceDefaultProfile( Model ):
   profileName = Str( help='Default Interface Profile Name' )
   profileAttributes = Submodel( valueType=InterfaceProfile,
                                 help="Attributes of the default Interface profile",
                                 optional=True )

   def render( self ):
      print 'Interface Profile: %s' % self.profileName
      if self.profileAttributes:
         self.profileAttributes.render()


class MaintenanceInterfaces( Model ):
   __revision__ = 2

   def degrade( self, dictRepr, revision ):
      if revision < 2:
         dictRepr[ 'interfaces' ] = \
           MaintenanceInterfaceStatus().degrade( dictRepr[ 'interfaces' ], revision )
      return dictRepr

   interfaces = GeneratorDict( help="Maintenance mode information for interfaces",
                               valueType=MaintenanceInterfaceStatus,
                               keyType=Interface )
   def render( self ):
      for intf, status in self.interfaces:
         if status.state:
            print "%s is %s" % ( intf,
                                 maintenanceStateToStr[ status.state ] )
         status.render()

