# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from CliPlugin.IgmpSnoopingCli import igmpSnoopingSupportedGuard

def _showTechCmds():
   cmds = []
   if igmpSnoopingSupportedGuard( mode=None, token=None ) is None:
      cmds += [ 'show ip igmp snooping',
                'show igmp snooping querier detail',
                'show igmp snooping querier status',
                'show ip igmp snooping groups detail',
                'show ip igmp snooping counters detail',
                'show ip igmp snooping mrouter detail',
      ]
   return cmds

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
         '2010-01-01 00:13:00',
         _showTechCmds,
         summaryCmdCallback=lambda: [ 'show igmp snooping querier' ] )
