# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.
import re

import BasicCli
import CliPlugin.IgmpSnoopingCli as IgmpSnoopingCli
import CliPlugin.IpAddrMatcher as IpAddrMatcher
import CliToken.Ip
import CliToken.IgmpSnooping
from EthIntfCli import EthPhyAutoIntfType
from IgmpSnoopingModel import IgmpSnoopingProxyInfo, IgmpSnoopingProxyPorts
from IgmpSnoopingModel import IgmpSnoopingProxyGroups, IgmpSnoopingProxySourceList
from IgmpSnoopingModel import IgmpSnoopingProxyGroupInfo
from Intf.IntfRange import IntfRangeMatcher
from LagIntfCli import LagAutoIntfType
import LazyMount
import ShowCommand
import Tac

igmpHostDir = None

def doShowIpIgmpSnoopingProxyGroups( mode, args ):
   groupAddr = args.get( 'IP_ADDR' )
   vlanId = args.get( 'VLAN_ID' )
   intfs = args.get( 'INTF' )
   detail = 'detail' in args

   if groupAddr:
      invalidMulticast = IpAddrMatcher.validateMulticastIpAddr( groupAddr )
      if invalidMulticast:
         mode.addError( "Group filter must be a valid multicast address" )
         return None
 
   if vlanId and intfs:
      hostList = [ ]
      for intfName in intfs.intfNames( shortName=False ) :
         hostKey = "Vlan%d%s" % ( vlanId, intfName )
         if hostKey in igmpHostDir.igmpHost:
            hostList.append( igmpHostDir.igmpHost[ hostKey ] ) 
   else:
      if vlanId or intfs :
         if vlanId :
            pattern = "Vlan%d.*" % vlanId
            regExp = re.compile( pattern )
            hostList = [ v for ( k, v ) in igmpHostDir.igmpHost.items() 
                  if regExp.match( k ) ]

         if intfs:
            hostList = []
            for intf in intfs.intfNames( shortName=False ) :
               pattern = r"Vlan\d+%s" % intf
               regExp = re.compile( pattern )
               tempList = [ v for ( k, v ) in igmpHostDir.igmpHost.items() 
                  if regExp.match( k ) ]
               hostList.extend( tempList )
      else:
         hostList =  igmpHostDir.igmpHost.values()

   model = IgmpSnoopingProxyInfo()
   model.detail = detail
   regExp = re.compile( r"Vlan(\d+)(.*)")
   for host in hostList:
      match = regExp.search( host.name )
      assert match
      ( vlanStr, interface ) = match.groups()
      vlanId = int( vlanStr )

      pModel = IgmpSnoopingProxyGroups()

    
      if groupAddr :
         groupRecs = []
         if groupAddr in host.v3group :
            groupRecs.append( ( groupAddr, host.v3group[ groupAddr ] ) )
      else:
         groupRecs = host.v3group.items() 
      
      for ( group, groupRecord ) in groupRecs:
         groupInfo = IgmpSnoopingProxyGroupInfo() 
         pModel.groups[ group ] = groupInfo
         if detail:
            sourceListModel = IgmpSnoopingProxySourceList()
            sourceListModel.sources = [ 
                  source for source in groupRecord.source.sourceIp ]
            sourceListModel.filterMode = "Exclude" if \
                  groupRecord.filterMode == "igmpV3ModeIsExclude" else "Include"
            groupInfo.sourceList = sourceListModel

      if pModel.groups:
         if vlanId in model.vlanInfo:
            vModel = model.vlanInfo[ vlanId ]
         else:
            vModel = IgmpSnoopingProxyPorts()
            model.vlanInfo[ vlanId ] = vModel
         vModel.portInfo[ interface ] = pModel

   return model

#--------------------------------------------------------------------------------
# show ip igmp snooping groups proxy [ IP_ADDR ] [ vlan VLAN_ID ]
#                                    [ interface INTF ] [ detail ]
#--------------------------------------------------------------------------------
class IpIgmpSnoopingGroupsProxyCmd( ShowCommand.ShowCliCommandClass ):
   syntax = ( 'show ip igmp snooping groups proxy [ IP_ADDR ] [ vlan VLAN_ID ] '
                                                  '[ interface INTF ] [ detail ]' )
   data = {
      'ip' : CliToken.Ip.ipMatcherForShow,
      'igmp' : CliToken.IgmpSnooping.igmpNode,
      'snooping' : CliToken.IgmpSnooping.snoopingMatcher,
      'groups' : 'Show IGMP group related information',
      'proxy' : 'IGMP Snooping Proxy Information',
      'IP_ADDR' : IpAddrMatcher.ipAddrMatcher,
      'vlan' : CliToken.IgmpSnooping.vlanMatcher,
      'VLAN_ID' : IgmpSnoopingCli.vlanIdMatcher,
      'interface' : 'Interface configuration',
      'INTF' : IntfRangeMatcher( explicitIntfTypes=( EthPhyAutoIntfType,
                                                     LagAutoIntfType ) ),
      'detail' : 'detail',
   }

   handler = doShowIpIgmpSnoopingProxyGroups
   cliModel = IgmpSnoopingProxyInfo

BasicCli.addShowCommandClass( IpIgmpSnoopingGroupsProxyCmd )
            
def Plugin( em ):
   global igmpHostDir

   igmpHostDir = LazyMount.mount( em, 'bridging/igmpsnooping/proxy/igmphost/config',
         'Igmp::IgmpHostDir', 'r' )

