#!/usr/bin/env python
# Copyright (c) 2015 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
import CliMatcher
import CliPlugin.VlanCli as VlanCli
import CliToken.Ip
import CliToken.IgmpSnooping
import ConfigMount
import Tac

# Tokens 
proxyMatcher = CliMatcher.KeywordMatcher( 'proxy', 
      helpdesc='Configure IGMP Snooping Proxy' )

# Entities
igmpSnoopingProxyConfig = None

#-------------------------------------------------------------------------------
# [ no | default ] ip igmp snooping proxy
#-------------------------------------------------------------------------------
class IgmpSnoopingProxyCmd( CliCommand.CliCommandClass ):
   syntax = 'ip igmp snooping proxy'
   noOrDefaultSyntax = syntax
   data = {
      'ip' : CliToken.Ip.ipMatcherForConfig,
      'igmp' : CliToken.IgmpSnooping.igmpNode,
      'snooping' : CliToken.IgmpSnooping.snoopingMatcher,
      'proxy': proxyMatcher
   }

   @staticmethod
   def handler( mode, args ):
      igmpSnoopingProxyConfig.globalEnabled = True

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      igmpSnoopingProxyConfig.globalEnabled = False

BasicCli.GlobalConfigMode.addCommandClass( IgmpSnoopingProxyCmd )
                  
# -----------------------------------------------------------------------------------
#  [no|default] ip igmp snooping vlan VLANS proxy
# ----------------------------------------------------------------------------------
class IgmpSnoopingVlanProxyCmd( CliCommand.CliCommandClass ):
   syntax = 'ip igmp snooping vlan VLANS proxy'
   noOrDefaultSyntax = syntax
   data = {
      'ip' : CliToken.Ip.ipMatcherForConfig,
      'igmp' : CliToken.IgmpSnooping.igmpNode,
      'snooping' : CliToken.IgmpSnooping.snoopingMatcher,
      'vlan' : CliToken.IgmpSnooping.vlanMatcher,
      'VLANS' : VlanCli.vlanSetMatcher,
      'proxy': proxyMatcher
   }

   @staticmethod
   def handler( mode, args ):
      for vlanId in args[ 'VLANS' ].ids:
         igmpSnoopingProxyConfig.vlanProxyState[ vlanId ] = True
      if not igmpSnoopingProxyConfig.globalEnabled:
         mode.addWarning( """ 'ip igmp snooping proxy' not enabled, so the command 
            will have no effect.""" )  

   @staticmethod
   def noHandler( mode, args ):
      for vlanId in args[ 'VLANS' ].ids:
         igmpSnoopingProxyConfig.vlanProxyState[ vlanId ] = False

   @staticmethod
   def defaultHandler( mode, args ):
      for vlanId in args[ 'VLANS' ].ids:
         del igmpSnoopingProxyConfig.vlanProxyState[ vlanId ]

BasicCli.GlobalConfigMode.addCommandClass( IgmpSnoopingVlanProxyCmd )
                  
def Plugin( em ):
   global igmpSnoopingProxyConfig
   igmpSnoopingProxyConfig = ConfigMount.mount( em, 
         'bridging/igmpsnooping/proxy/config', 'Igmp::Snooping::Proxy::Config', 'w' )

