#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

#-------------------------------------------------------------------------------
# Implements no CLI commands.  Contains code to delete config objects values
# when interfaces are deleted.
#-------------------------------------------------------------------------------
import IntfCli, ConfigMount 

snoopConfig = None

class IgmpSnoopingIntfJanitor( IntfCli.IntfDependentBase ):
   """This class is responsible for removing static routers/hosts associated with
   that interface when an interface gets deleted.""" 

   def destroy( self ):
      intfName = self.intf_.name
      vlanConfig = snoopConfig.vlanConfig
      for vlan in vlanConfig.values():
         del vlan.routerIntf[ intfName ]
         for group in vlan.ipGroup.values():
            del group.intf[ intfName ]

def Plugin( entityManager ):  
   global snoopConfig
   snoopConfig = ConfigMount.mount( entityManager, "bridging/igmpsnooping/config",
                                    "Bridging::IgmpSnooping::Config", "w" )
   IntfCli.Intf.registerDependentClass( IgmpSnoopingIntfJanitor ) 

