#!/usr/bin/env python
# Copyright (c) 2011 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import AgentCommandRequest
import BasicCli
import CliCommand
import CliToken.Ip
import CliToken.IgmpSnooping
import CommonGuards
from IgmpSnoopingLib import agentName
import ShowCommand

class IpIgmpSnoopingGroupsProxyCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show ip igmp snooping counters ethdev-pams'
   data = {
      'ip' : CliToken.Ip.ipMatcherForShow,
      'igmp' : CliToken.IgmpSnooping.igmpNode,
      'snooping' : CliToken.IgmpSnooping.snoopingMatcher,
      'counters' : 'counters',
      'ethdev-pams' : CliCommand.guardedKeyword( 'ethdev-pams',
         helpdesc='Ethernet device pams counters', guard=CommonGuards.standbyGuard )
      }

   @staticmethod
   def handler( mode, args ):
      cmd = 'ethDevPamsCounters'
      AgentCommandRequest.runSocketCommand( mode.entityManager,
                                            agentName(),
                                            'igmpsnoopingdebug', cmd )

BasicCli.addShowCommandClass( IpIgmpSnoopingGroupsProxyCmd )
