#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import CliCommand
import CliPlugin.IgmpCli as IgmpCli
from CliPlugin.VrfCli import VrfExprFactory

#--------------------------------------------------------------------------------
# [ no | default ] vrf VRF
#--------------------------------------------------------------------------------
class VrfCmd( CliCommand.CliCommandClass ):
   syntax = 'VRF'
   noOrDefaultSyntax = syntax
   data = {
      'VRF' : VrfExprFactory( helpdesc='Configure IGMP in a VRF' ),
   }
   handler = IgmpCli.gotoRouterIgmpVrfMode
   noOrDefaultHandler = IgmpCli.deleteRouterIgmpVrfMode

IgmpCli.RouterIgmpMode.addCommandClass( VrfCmd )
