#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.IgmpCli as IgmpCli
from CliPlugin.IgmpShowCommands import nodeIgmp
from CliToken.Router import routerMatcherForConfig

#--------------------------------------------------------------------------------
# [ no | default ] router igmp
#--------------------------------------------------------------------------------
class RouterIgmpCmd( CliCommand.CliCommandClass ):
   syntax = 'router igmp'
   noOrDefaultSyntax = syntax
   data = {
      'router' : routerMatcherForConfig,
      'igmp' : nodeIgmp,
   }
   handler = IgmpCli.gotoRouterIgmpMode
   noOrDefaultHandler = IgmpCli.deleteRouterIgmpMode

BasicCliModes.GlobalConfigMode.addCommandClass( RouterIgmpCmd )
