# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliToken.Clear import clearKwNode
from AgentCommandRequest import ( RunSocketCommandException,
                                  runSocketCommand )
import AgentDirectory

class ClearHealthMonitorProbeDelayCmd( CliCommand.CliCommandClass ):
   syntax = "clear health-monitor probe delay"
   data = {
         "clear": clearKwNode,
         "health-monitor": "Clear health-monitor information",
         "probe": "Clear health-monitor probe information",
         "delay": "Clear health-monitor probe delay"
   }

   @staticmethod
   def handler( mode, args ):
      command = "clear health-monitor probe delay"
      if not AgentDirectory.agent( mode.entityManager.sysname(), "HealthMonitor" ):
         mode.addError( "HealthMonitor agent is not running" )
         return
      try:
         runSocketCommand( mode.entityManager, "HealthMonitor",
               "HmCli", command )
      except RunSocketCommandException, e:
         mode.addError( str( e ) )

BasicCli.EnableMode.addCommandClass( ClearHealthMonitorProbeDelayCmd )
