# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

class HealthStatusReactor( Tac.Notifiee ):
   notifierTypeName = "Health::Status"

   def __init__( self, status ):
      Tac.Notifiee.__init__( self, status )
      self.handleStatusEnabled()

   @Tac.handler( 'enabled' )
   def handleStatusEnabled( self ):
      if self.notifier_.enabled:
         self.handleEnabled()
      else:
         self.handleDisabled()

   def handleEnabled( self ):
      raise NotImplementedError

   def handleDisabled( self ):
      raise NotImplementedError
