# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliCommand
from CliMode.HardwareLed import HardwareLedMode
import CliParser
import CliToken.Hardware

class LedMode( HardwareLedMode, BasicCli.ConfigModeBase ):
   name = 'LED'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session ):
      HardwareLedMode.__init__( self, None )
      BasicCli.ConfigModeBase.__init__( self, parent, session )

#--------------------------------------------------------------------------------
# hardware led
#--------------------------------------------------------------------------------
class HardwareLedCmd( CliCommand.CliCommandClass ):
   syntax = 'hardware led'
   data = {
      'hardware' : CliToken.Hardware.hardwareMatcherForConfig,
      'led' : 'User configured LED mode',
   }
   hidden = True

   @staticmethod
   def handler( mode, args ):
      childMode = mode.childMode( LedMode )
      mode.session_.gotoChildMode( childMode )

BasicCli.GlobalConfigMode.addCommandClass( HardwareLedCmd )
