# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import ConfigMount

globalAllGroupConfigDir = None

#
# Group class: Provides Library to add/remove each configured group into
# 'all' collection
#
class Group( object ):
   def __init__( self, groupKey ):
      self.key_ = groupKey

   def key( self ):
      return self.key_

   def addGroup( self ):
      globalAllGroupConfigDir.newConfig( self.key_ )

   def remGroup( self ):
      del globalAllGroupConfigDir.config[ self.key_ ]

class GroupConfigMode( object ):
   def __init__( self, session, group ):
      self.session_ = session
      self.group_ = group
   
   def group( self ):
      return self.group_

def Plugin( entityManager ):
   global globalAllGroupConfigDir
   globalAllGroupConfigDir = ConfigMount.mount( entityManager,
      'group/config/all', 'Group::ConfigDir', 'w' )
