#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.GatedBgpCli as GatedBgpCli
import CliPlugin.VrfCli as VrfCli

matcherBgp = CliMatcher.KeywordMatcher( 'bgp',
      helpdesc='BGP information' )
matcherExportTable = CliMatcher.KeywordMatcher( 'export-table',
      helpdesc='Show export table' )
vrfExprFactory = VrfCli.VrfExprFactory(
      helpdesc='Display VRF state',
      inclDefaultVrf=True )

#--------------------------------------------------------------------------------
# show bgp export-table adj-rib-in [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableAdjRibInCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table adj-rib-in [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'adj-rib-in' : 'BGP AdjRibIn path info',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpPathSmashTable

BasicCli.addShowCommandClass( BgpExportTableAdjRibInCmd )

#--------------------------------------------------------------------------------
# show bgp export-table aspath [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableAspathCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table aspath [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'aspath' : 'BGP aspath info',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpAsPathSmashTable

BasicCli.addShowCommandClass( BgpExportTableAspathCmd )

#--------------------------------------------------------------------------------
# show bgp export-table bgp-attributes-id [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableBgpAttributesIdCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table bgp-attributes-id [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'bgp-attributes-id' : 'BGP attributes ID table',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpAttrsIdTable

BasicCli.addShowCommandClass( BgpExportTableBgpAttributesIdCmd )

#--------------------------------------------------------------------------------
# show bgp export-table bgp-nexthops [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableBgpNexthopsCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table bgp-nexthops [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'bgp-nexthops' : 'BGP nexthops table',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpNexthopsTable

BasicCli.addShowCommandClass( BgpExportTableBgpNexthopsCmd )

#--------------------------------------------------------------------------------
# show bgp export-table community [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableCommunityCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table community [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'community' : 'BGP community info',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpCommSmashTable

BasicCli.addShowCommandClass( BgpExportTableCommunityCmd )

#--------------------------------------------------------------------------------
# show bgp export-table ext-community [ raw ] [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableExtCommunityCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table ext-community [ raw ] [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'ext-community' : 'BGP extended community info',
      'raw' : 'Show raw BGP AdjRibIn extended community value',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpExtCommSmashTable

BasicCli.addShowCommandClass( BgpExportTableExtCommunityCmd )

#--------------------------------------------------------------------------------
# show bgp export-table global-info [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableGlobalInfoCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table global-info [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'global-info' : 'BGP global info',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpGlobalInfo

BasicCli.addShowCommandClass( BgpExportTableGlobalInfoCmd )

#--------------------------------------------------------------------------------
# show bgp export-table path-attribute [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTablePathAttributeCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table path-attribute [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'path-attribute' : 'Path attribute table',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpAttrTable

BasicCli.addShowCommandClass( BgpExportTablePathAttributeCmd )

#--------------------------------------------------------------------------------
# show bgp export-table peer [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTablePeerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table peer [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'peer' : 'BGP peer info',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpPeerSmashTable

BasicCli.addShowCommandClass( BgpExportTablePeerCmd )

#--------------------------------------------------------------------------------
# show bgp export-table rib ( ipv4-unicast | ipv6-unicast ) [ VRF ]
#--------------------------------------------------------------------------------
class BgpExportTableRibCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show bgp export-table rib ( ipv4-unicast | ipv6-unicast ) [ VRF ]'
   data = {
      'bgp' : matcherBgp,
      'export-table' : matcherExportTable,
      'rib' : 'BGP Loc-RIB path info',
      'ipv4-unicast' : 'IPv4 related',
      'ipv6-unicast' : 'IPv6 related',
      'VRF' : vrfExprFactory,
   }

   handler = GatedBgpCli.showBgpAttrSmashTable

BasicCli.addShowCommandClass( BgpExportTableRibCmd )
