#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliPlugin.AssetTags as AssetTags
from CliPlugin.AssetTagsModel import Assets
from CliPlugin.FruCli import SwitchOrModuleExpression
import ShowCommand
from CliToken.Hardware import hardwareMatcherForShow

#--------------------------------------------------------------------------------
# show hardware asset-tag [ MODULE ]
#--------------------------------------------------------------------------------
class HardwareAssetTagCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show hardware asset-tag [ MODULE ]'
   data = {
      'hardware' : hardwareMatcherForShow,
      'asset-tag' : 'User-specified asset tags/IDs',
      'MODULE' : SwitchOrModuleExpression,
   }

   handler = AssetTags.doShowAssetTag
   cliModel = Assets

BasicCli.addShowCommandClass( HardwareAssetTagCmd )
