#!/usr/bin/env python
# Copyright (c) 2020 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

from CliPlugin import TechSupportCli

#---------------------------------------------------------------------------
# 'show tech-support extended flow-spec'
# include 'show flow-spec ipv4', 'show flow-spec ipv6'
#--------------------------------------------------------------------------
def _showTechFlowspecCmds():
   return [
      'show flow-spec ipv4 vrf all summary',
      'show flow-spec ipv6 vrf all summary',
      'show flow-spec ipv4 vrf all',
      'show flow-spec ipv6 vrf all',
      'show hardware capacity',
      'show platform fap tcam summary',
      'show platform fap acl tcam hw',
   ]

TechSupportCli.registerShowTechSupportCmdCallback( '2018-09-25 15:12:00',
      _showTechFlowspecCmds,
      extended='flow-spec' )

#---------------------------------------------------------------------------
# 'show tech-support' and 'show tech-support summary'
# include 'show flow-spec ipv4 summary', 'show flow-spec ipv6 summary'
#--------------------------------------------------------------------------
def _showTechSummaryFlowspecCmds():
   return [
      'show flow-spec ipv4 vrf all summary',
      'show flow-spec ipv6 vrf all summary',
   ]

TechSupportCli.registerShowTechSupportCmdCallback( '2018-09-25 15:12:00',
      _showTechSummaryFlowspecCmds,
      summaryCmdCallback=_showTechSummaryFlowspecCmds )
