#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli
from AgentDirectory import agentIsRunning

sysname = None

#-------------------------------------------------------------------------------
# Firewall commands in 'show tech-support'
#-------------------------------------------------------------------------------

def _firewallShowTechCmds():
   cmds = []
   if agentIsRunning( sysname, 'Firewall' ):
      cmds.extend( [
               'show segment-security',
               'show segment-security policy',
               'show segment-security application',
      ] )
   return cmds

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      '2019-08-01 09:30:04', _firewallShowTechCmds )

def Plugin( entityManager ):
   global sysname
   sysname = entityManager.sysname()
