#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Tac

#------------------------------------------------------------------------------------
# Context
# A context is created for FirewallPolicyConfigMode and stores(buffers) the command
# till the user exists the mode or aborts the changes.
#
# If the policy exists already, the context contains an editable copy of the
# contents; else it contains a new (editable) copy
#------------------------------------------------------------------------------------
class Context( object ):
   def __init__( self, policyName, segSecPolicy ):
      self.policyName = policyName
      self.policy = segSecPolicy
      self.tmpPolicy = None
      self.mode_ = None
      self.copyPolicy()

   def copyPolicy( self ):
      self.tmpPolicy = Tac.newInstance( "Firewall::Policy", self.policyName )
      if self.policyName in self.policy:
         pol = self.policy[ self.policyName ]
         self.tmpPolicy.lastSeqNum = pol.lastSeqNum
         for app in pol.serviceToSeqnum:
            self.tmpPolicy.serviceToSeqnum[ app ] = pol.serviceToSeqnum[ app ]
         for seqnum in pol.rule:
            rule = pol.rule[ seqnum ]
            self.tmpPolicy.rule.newMember( seqnum, rule.serviceName,
                                           rule.action, rule.log )

   def modeIs( self, mode ):
      self.mode_ = mode

   def commit( self ):
      if self.policyName not in self.policy:
         self.policy.newMember( self.policyName )

      pol = self.policy[ self.policyName ]
      pol.lastSeqNum = self.tmpPolicy.lastSeqNum

      for app in self.tmpPolicy.serviceToSeqnum:
         pol.serviceToSeqnum[ app ] = self.tmpPolicy.serviceToSeqnum[ app ]

      # delete case
      for app in pol.serviceToSeqnum:
         if app not in self.tmpPolicy.serviceToSeqnum:
            del pol.serviceToSeqnum[ app ]

      for seqnum in self.tmpPolicy.rule:
         rule = self.tmpPolicy.rule[ seqnum ]
         if seqnum in pol.rule:
            del pol.rule[ seqnum ]
         pol.rule.newMember( seqnum, rule.serviceName,
                             rule.action, rule.log )
      # delete case
      for seqnum in pol.rule:
         if seqnum not in self.tmpPolicy.rule:
            del pol.rule[ seqnum ]

   def abort( self ):
      self.policyName = None
      self.tmpPolicy = None
