#!/usr/bin/env python
# Copyright (c) 2016 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Ark
import CliModel

class ConditionAndChangedStat( CliModel.Model ):
   value = CliModel.Bool( help="Whether or not a condition is true or present" )
   changes = CliModel.Int( help="The number of times the condition changed" )
   lastChange = CliModel.Float( help="The last time the condition changed" )

   def toModel( self, event ):
      self.value = bool( event.current )
      self.changes = event.changes
      self.lastChange = Ark.switchTimeToUtc( event.lastChange )
      return self

class CountAndChangedStat( CliModel.Model ):
   value = CliModel.Int( help="Last non-zero counter value" )
   changes = CliModel.Int( help="The number of times the count was non-zero" )
   lastChange = CliModel.Float( help="The last time the count was non-zero" )

   def toModel( self, event ):
      self.value = event.count
      self.changes = event.changes
      self.lastChange = Ark.switchTimeToUtc( event.lastChange )
      return self
