#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import CliMatcher
import ShowCommand
import CliPlugin.EventCli as EventCli
from CliPlugin.EventCliModel import EventHandlers, EventHandlerTrigger

matcherEventHandler = CliMatcher.KeywordMatcher( 'event-handler',
      helpdesc='Show event-handler status' )

#--------------------------------------------------------------------------------
# show event-handler [ EVENT_HANDLER ]
#--------------------------------------------------------------------------------
class EventHandlerCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show event-handler [ EVENT_HANDLER ]'
   data = {
      'event-handler': matcherEventHandler,
      'EVENT_HANDLER': EventCli.eventHandlerNameMatcher
   }
   handler = EventCli.doShowEventStatus
   cliModel = EventHandlers
   privileged = True

BasicCli.addShowCommandClass( EventHandlerCmd )

#--------------------------------------------------------------------------------
# show event-handler trigger counters [ sources ]
#--------------------------------------------------------------------------------
class EventHandlerTriggerCountersCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show event-handler trigger counters [ sources ]'
   data = {
      'event-handler': matcherEventHandler,
      'trigger': 'Show event-handler supported trigger parameters',
      'counters': 'Show event-handler supported trigger counters',
      'sources': 'Show event-handler supported trigger counter sources',
   }
   handler = EventCli.doShowCounters
   cliModel = EventHandlerTrigger
   privileged = True

BasicCli.addShowCommandClass( EventHandlerTriggerCountersCmd )
