# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliCommand
import CliPlugin.EthIntfCli as EthIntfCli
import CliPlugin.IntfGroupLib as IntfGroupLib
import CliPlugin.MaintenanceCliLib as MaintenanceCliLib
import Intf

class MemberCmd( CliCommand.CliCommandClass ):
   syntax = 'interface INTFS'
   noOrDefaultSyntax = syntax
   data = {
      'interface' : 'Configure member',
      'INTFS' : Intf.IntfRange.IntfRangeMatcher( noSingletons=False,
         explicitIntfTypes=( EthIntfCli.EthPhyAutoIntfType, ) ),
   }

   @staticmethod
   def handler( mode, args ):
      intfs = args[ 'INTFS' ]
      if MaintenanceCliLib.isSubIntf( str( intfs ) ):
         mode.addError( "Sub-interface config is not supported" )
         return
      mode.group().addIntf( intfs )

   @staticmethod
   def noOrDefaultHandler( mode, args ):
      intfs = args[ 'INTFS' ]
      if MaintenanceCliLib.isSubIntf( str( intfs ) ):
         mode.addError( "Sub-interface config is not supported" )
         return
      mode.group().remIntf( intfs )

IntfGroupLib.IntfGroupConfigMode.addCommandClass( MemberCmd )
