#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.InstallCli as InstallCli
from CliToken.Install import installMatcher, sourceMatcher, reloadMatcher, nowMatcher
from Url import UrlMatcher

#--------------------------------------------------------------------------------
# install source SOURCE [ destination DESTINATION ] [ reload ] [ now ]
#--------------------------------------------------------------------------------
class InstallSourceCmd( CliCommand.CliCommandClass ):
   syntax = 'install source SOURCE [ destination DESTINATION ] [ reload ] [ now ]'
   data = {
      'install': installMatcher,
      'source': sourceMatcher,
      'SOURCE': UrlMatcher( fsFunc=lambda fs: fs.scheme != 'system:',
                                helpdesc='Source path' ),
      'destination': 'Provide a destination path',
      'DESTINATION': UrlMatcher( fsFunc=lambda fs: fs.scheme == 'flash:',
                                     helpdesc='Destination path' ),
      'reload': reloadMatcher,
      'now': nowMatcher,
   }
   handler = InstallCli.doInstall

BasicCliModes.EnableMode.addCommandClass( InstallSourceCmd )
