#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
import CliPlugin.EbraSnmpCli as EbraSnmpCli
import CliPlugin.IntfCli as IntfCli
from CliPlugin.SnmpCli import snmpKwMatcher, mibKwMatcherForShow

#--------------------------------------------------------------------------------
# show snmp mib bridgemib portid [ INTF ]
#--------------------------------------------------------------------------------
class SnmpMibBridgemibPortidCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show snmp mib bridgemib portid [ INTF ]'
   data = {
      'snmp': snmpKwMatcher,
      'mib': mibKwMatcherForShow,
      'bridgemib': 'Show SNMP BRIDGE-MIB contents',
      'portid': 'Show BRIDGE-MIB dot1dBasePort',
      'INTF': IntfCli.Intf.rangeMatcher,
   }
   handler = EbraSnmpCli.showSnmpPortId
   cliModel = EbraSnmpCli.PortIDs

BasicCli.addShowCommandClass( SnmpMibBridgemibPortidCmd )
