#!/usr/bin/env python
# Copyright (c) 2013 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import Arnet
import IntfCli, EthIntfCli
from CliModel import Dict, Model

class PortIDs( Model ):

   portIDs = Dict( keyType=str, valueType=int,
                   help='Map an interface name to a port id' )

   def render( self ):
      for name in Arnet.sortIntf( self.portIDs ):
         print '%s:  Port ID = %d' % ( name, self.portIDs[ name ] )

#-------------------------------------------------------------------------------
# The "show snmp mib bridgemib portid [interfaceName]" command, in "enable" mode.
#-------------------------------------------------------------------------------

def showSnmpPortId( mode, args ):

   intf = args.get( 'INTF' )

   intfs = IntfCli.Intf.getAll( mode, intf, None, EthIntfCli.EthIntf )
   if not intfs:
      return PortIDs()

   intfs = [ i for i in intfs if i.lookup() ]
   if not intfs:
      return PortIDs()

   portIDs = {}
   for i in intfs:
      portIDs[ i.name ] = i.status().portId

   return PortIDs( portIDs=portIDs )

