# Copyright (c) 2012 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliPlugin.TechSupportCli # pylint: disable-msg=F0401
from CliPlugin.VlanCli import vlanMappingSupportedGuard
from Toggles.EbraToggleLib import toggleMplsEvpnVpwsP2Enabled

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:04:15',
                                lambda : [ 'show interfaces switchport' ] )

# Timestamps are made up to maintain historical order
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:05:00',
                                lambda : [ 'show vlan' ] )

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2010-01-01 00:05:10',
                                lambda : [ 'show mac address-table' ] )

# Also add show mac address-table to show tech-support extended evpn
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback( 
                                '2017-11-03 12:06:07',
                                lambda : [ 'show mac address-table' ],
                                extended = 'evpn' )

# Timestamps are made up to maintain historical order within show tech-support
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      "2016-12-19 09:30:00",
      lambda : [ 'show switch forwarding-mode' ] )

def _showTechCmds1():
   cmds = []
   if vlanMappingSupportedGuard( mode=None, token=None ) is None:
      cmds.append( 'show interfaces switchport vlan mapping' )
   return cmds

CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      "2017-11-20 17:23:22",
      _showTechCmds1 )

# Add show interfaces {trunk, trunk phone}
CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
      '2019-09-20 10:00:00',
      lambda: [
         'show interfaces trunk',
         'show interfaces trunk phone',
      ],
      summaryCmdCallback=lambda: [ 'show vlan brief count' ] )

# Add show interface encapsulation vlan
if toggleMplsEvpnVpwsP2Enabled():
   CliPlugin.TechSupportCli.registerShowTechSupportCmdCallback(
         '2020-02-21 15:10:00',
         lambda: [
            'show interface encapsulation vlan',
         ] )
