# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import LazyMount
import CliMatcher
from CliPlugin.RouteMapCli import rtMapCommListPreListRe
dynPfxListConfigDir = None

disallowRegex = "[vV][rR][fF]"
dynPfxListNamePattern = ( '^(?!%s$)%s' % ( disallowRegex, rtMapCommListPreListRe ) )

dynPfxListNameMatcher = CliMatcher.DynamicNameMatcher(
    lambda mode: dynPfxListConfigDir.dynamicPrefixList.members(),
    helpdesc='Name of dynamic prefix-list',
    pattern=dynPfxListNamePattern )

def getDplConfigParams( dplName ):
   dplConfig = dynPfxListConfigDir.dynamicPrefixList.get( dplName, None )
   if dplConfig:
      return ( dplConfig.matchMap, dplConfig.ipv4PrefixList, 
               dplConfig.ipv6PrefixList )
   else:
      return ( None, None, None )

def Plugin( entityManager ):
   global dynPfxListConfigDir
   dynPfxListConfigDir = LazyMount.mount(
      entityManager, 'routing/dynPfxList/config',
      'Routing::DynamicPrefixList::Config', 'r' )
