# Copyright (c) 2006, 2007, 2008 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import os

import BasicCli
import ShowCommand

def showChickens( mode, args ):
   print(
"""Farm utilization for five seconds: 0%/0%; one minute: 0%; five minutes: 0%
 DID S  Ty       DC  Runtime(ms)      Rides   Poops       Hay DKY Donkeyname
   1 M  sp 602F3AF0            0       1627       0 2600/3000   0 Eeyore
   2 F  we 60C5BE00            4        136      29 5572/6000   0 Tingaleo
   3 F  st 602D90F8         1676        837    2002 5740/6000   0 Daisy
   4 M  we 602D08F8            0          1       0 5568/6000   0 Wonky Don
   5 F  we 602DF0E8            0          1       0 5592/6000   0 Dakota
   6 M  st 60251E38            0          2       0 5560/6000   0 Superdonkey
   7 M  we 600D4940            0          2       0 5568/6000   0 Cookie Dough
   8 F  we 6034B718            0          1       0 2584/3000   0 Sandy
   9 F  we 603FA3C8            0          1       0 5612/6000   0 Kekie
  10 M  we 603FA1A0            0       8124       0 5488/6000   0 Shrek
  11 M  we 603FA220            0          9       0 4884/6000   0 Billy Joe-Bob
  12 U  we 60406818          124       2003      61 5300/6000   0 Smokey
  13 M  we 60581638            0          1       0 5760/6000   0 Snickers
  14 M  we 605E3D00            0          2       0 5564/6000   0 D.K.
  15 M  we 605FC6B8            0          2       011568/12000  0 Hee-Haw

                                  /\\          /\\
                                 ( \\\\        // )
                                  \\ \\\\      // /
                                   \\_\\\\||||//_/
                                    \\/ _  _ \\
                                   \\/|(o)(O)|
                                  \\/ |      |
              ___________________\\/  \\      /
             //                //     |____|       Cluck cluck cluck!
            //                ||     /      \\
           //|                \\|     \\ 0  0 /
          // \\       )         V    / \\____/
         //   \\     /        (     /
        ""     \\   /_________|  |_/
               /  /\\   /     |  ||
              /  / /  /      \\  ||
              | |  | |        | ||
              | |  | |        | ||
              |_|  |_|        |_||
               \\_\\  \\_\\        \\_\\\\
""" )

def showDonkeys( mode, args ):
   # This command existed to test internal aliases, but now we just
   # call the aliased method directly.
   showChickens( mode, args )

def showFarm( mode, args ):
   # This command exists to test running sub-commands
   cmds = [ "show chickens", "show donkeys" ]
   for cmd in cmds:
      print( "\n------------- %s -------------\n" % cmd )
      mode.session_.runCmd( cmd, aaa=False )

class ScaredyException( Exception ):
   pass

def showElephants( mode, args ):
   # This command exists to test cli exception handling
   raise ScaredyException( '''
                       ( ____     .-.
                .-""-. .'` _  `'-,//`|-.
               / ,-'-.`.  | \\     `. (  `\\
              |       `   \\  \\      `.)   \\
              |            \\_@    .=` \\    |
              |      /               .=\\    \\
              |     /                   \\    |
              |    .\\    ,____         ==;   |
              \\  __.-;.__.'--'`"-,       |   |
               `"`  /           _ \\    '=|   |
                   |         _.' \\_)     /   /
                   |  \\     (  _    '=_.'   |
                   \\   \\   .-`` `---'`      |              _
                    \\   \\ | =   ,      ,   /            ,_( ))
                     )   `|     \\__.-'`   /              \\' /  .--.
                     /`   |nnn  / \\      /              =/ \\  (
              jgs   /     ;""""`nn|     (                \\_ \\  )
                   (nnn__.'       '-nnn-'               _(   |`
                                              `"""`
''' )

def showPlugh( mode, args ):
   # This is pretty fundamentally dangerous, so you have to go
   # create a file in the filesystem to make it clear that you
   # want to do it.
   if not os.path.exists( '/tmp/xyzzy' ):
      mode.addError( 'A hollow voice says, "fool".' )
   else:
      import ctypes
      libc = ctypes.CDLL( "libc.so.6" )
      libc.__assert_fail( 0, 0, 0, 0 )  # pylint:disable=protected-access

#------------------------------------------------------------------------------------
# show chickens
#------------------------------------------------------------------------------------
class ShowChickens( ShowCommand.ShowCliCommandClass ):
   syntax = '''show chickens'''
   data = { 'chickens': 'Shows the status of the donkeys' }
   handler = showChickens
   hidden = True

BasicCli.addShowCommandClass( ShowChickens )
#------------------------------------------------------------------------------------
# show donkeys
#------------------------------------------------------------------------------------

class ShowDonkeys( ShowCommand.ShowCliCommandClass ):
   syntax = '''show donkeys'''
   data = { 'donkeys': 'Shows the status of the donkeys' }
   handler = showDonkeys
   hidden = True

BasicCli.addShowCommandClass( ShowDonkeys )
#------------------------------------------------------------------------------------
# show elephants
#------------------------------------------------------------------------------------

class ShowElephants( ShowCommand.ShowCliCommandClass ):
   syntax = '''show elephants'''
   data = { 'elephants': 'Shows the status of the elephants' }
   handler = showElephants
   hidden = True

BasicCli.addShowCommandClass( ShowElephants )
#------------------------------------------------------------------------------------
# show farm
#------------------------------------------------------------------------------------

class ShowFarm( ShowCommand.ShowCliCommandClass ):
   syntax = '''show farm'''
   data = { 'farm': 'Shows the status of the farm' }
   handler = showFarm
   hidden = True

BasicCli.addShowCommandClass( ShowFarm )

#------------------------------------------------------------------------------------
# show plugh
#------------------------------------------------------------------------------------
class ShowPlugh( ShowCommand.ShowCliCommandClass ):
   syntax = '''show plugh'''
   data = { 'plugh': 'Shows the status of the magic word' }
   handler = showPlugh
   hidden = True

BasicCli.addShowCommandClass( ShowPlugh )
