# Copyright (c) 2017 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import CliParser, LazyMount

# Globals written by the Plugin function at the end of this file
dhcp6SnoopingHwStatusDir = None
platformHardwareSliceDir = None

def dhcp6SnoopingSupportedGuard( mode, token ):
   for sliceId, hwStatus in dhcp6SnoopingHwStatusDir.iteritems():
      sliceInfo = platformHardwareSliceDir.sliceInfo.get( sliceId )
      if sliceInfo and sliceInfo.generationId == hwStatus.genId and \
         hwStatus.dhcpSnoopingSupported:
         return None
   return CliParser.guardNotThisPlatform

#-------------------------------------------------------------------------------
# Have the Cli Agent mount all needed state from sysdb
#-------------------------------------------------------------------------------
def Plugin( entityManager ):
   global dhcp6SnoopingHwStatusDir
   global platformHardwareSliceDir

   dhcp6SnoopingHwStatusDir = LazyMount.mount( entityManager,
                                        "bridging/dhcpsnooping/hardware/dhcp6Status",
                                         "Tac::Dir", "ri" )
   platformHardwareSliceDir = LazyMount.mount( entityManager,
                                               "platform/hardware/slice",
                                               "Hardware::PlatformSliceDir", "r" )
