#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCli
import ShowCommand
import CliPlugin.DebugMessageCli as DebugMessageCli
from CliToken.Debugging import debuggingMatcherForShow

#--------------------------------------------------------------------------------
# show debugging
#--------------------------------------------------------------------------------
class DebuggingCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show debugging'
   data = {
      'debugging' : debuggingMatcherForShow,
   }
   handler = DebugMessageCli.showDebug

BasicCli.addShowCommandClass( DebuggingCmd )
