# Copyright (c) 2014 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import CliMode.CvxDebugService
import CliParser
import Tracing
t8 = Tracing.trace8

class CvxDebugServiceMode( CliMode.CvxDebugService.CvxDebugServiceMode, 
      BasicCli.ConfigModeBase ):
   name = 'CVX debug service configurations'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, serviceName=None ):
      t8( "initialize debug service configuration" )
      CliMode.CvxDebugService.CvxDebugServiceMode.__init__( self, serviceName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
      self.serviceName = serviceName
      self.isClient = False

class MgmtCvxDebugServiceMode( CliMode.CvxDebugService.MgmtCvxDebugServiceMode, 
      BasicCli.ConfigModeBase ):
   name = 'Management CVX debug service configurations'
   modeParseTree = CliParser.ModeParseTree()

   def __init__( self, parent, session, serviceName=None ):
      t8( "initialize debug service configuration" )
      CliMode.CvxDebugService.MgmtCvxDebugServiceMode.__init__( self, serviceName )
      BasicCli.ConfigModeBase.__init__( self, parent, session )
      self.serviceName = serviceName
      self.isClient = True #session.mode.modeKey == 'mgmt'

