#!/usr/bin/env python
# Copyright (c) 2019 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

from __future__ import absolute_import, division, print_function

import BasicCliModes
import CliCommand
import CliPlugin.DebugMessageCli as DebugMessageCli

#--------------------------------------------------------------------------------
# All non-dynamically generated commands in 'enable' mode
#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------
# ( undebug | ( no debug ) ) all
#--------------------------------------------------------------------------------
class AllCmd( CliCommand.CliCommandClass ):
   syntax = '( undebug | ( no debug ) ) all'
   data = {
      'undebug' : DebugMessageCli.matcherUndebug,
      'debug' : DebugMessageCli.matcherDebug,
      'no' : DebugMessageCli.matcherNo,
      'all' : 'All debug messages',
   }
   handler = DebugMessageCli.disableAllCategories

BasicCliModes.EnableMode.addCommandClass( AllCmd )
