#!/usr/bin/env python
# Copyright (c) 2018 Arista Networks, Inc.  All rights reserved.
# Arista Networks, Inc. Confidential and Proprietary.

import BasicCli
import ShowCommand
import AgentDirectory
import AgentCommandRequest
from CliPlugin.TechSupportCli import ( techSupportKwMatcher,
                                      extendedKwMatcher,
                                      registerShowTechSupportCmdCallback )

def isCspfAgentRunning( sysname ):
   agentName = 'Cspf'
   if AgentDirectory.agentIsRunning( sysname, agentName ):
      return True
   return False

def doShowTechCspf( mode, args ):
   if isCspfAgentRunning( mode.entityManager.sysname() ):
      command = 'DUMP_CSPF_STATE'
      AgentCommandRequest.runSocketCommand( mode.entityManager, "Cspf", "CspfDump",
                                            command )
   else:
      mode.addWarning( "CSPF agent is not active" )

#-------------------------------------------------------------------------------
# CSPF commands in 'show tech-support'
#-------------------------------------------------------------------------------

def _cspfShowTechCmds():
   return [
      'show traffic-engineering database',
      'show traffic-engineering cspf path detail',
      'show isis ti-lfa path detail'
   ]

registerShowTechSupportCmdCallback( '2018-06-22 01:00:16', _cspfShowTechCmds )

#--------------------------------------------------------------------------------
# show tech-support extended cspf
#--------------------------------------------------------------------------------
class TechSupportExtendedCspfCmd( ShowCommand.ShowCliCommandClass ):
   syntax = 'show tech-support extended cspf'
   data = {
      'tech-support' : techSupportKwMatcher,
      'extended' : extendedKwMatcher,
      'cspf' : 'Show detailed state of CSPF Agent',
   }
   handler = doShowTechCspf
   privileged = True

BasicCli.addShowCommandClass( TechSupportExtendedCspfCmd )
